//******************************************
// file			: main.c
// version		: V1.3 2024/08/07
// brief		: main program
// note			: 
//******************************************
#ifndef IO_MEM
#define IO_MEM
#endif

#include "main.h"


/* ---------------------- global variables ------------------------ */


/* ---------------------- main program -------------------------- */
void main(){
    /* ---------------------- system initialization ------------------------ */
    System_Init();    
    
    /* ---------------------- function initialization ------------------- */
//  external interrupt  (ExtINT)
//  use P75(INT2) as the external interrupt input.when an interrupt is generated by the input of a rising edge signal, P90 Ž output levelٴη
    ExtINT_Init();
    ExtINT_IntEnable();    


//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *    
    while(1){
        CLR_WDT;                        // clear the watchdog timer

        NOP;                            // no operation
        NOP;                            // no operation
        NOP;                            // no operation
    }
//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}




/*---------------------- interrupt service routine ------------------------*/
void __interrupt OnlyReti(void)
{
    NOP;                                // no operation
}

void __interrupt_n OnlyRetn(void)
{
    NOP;                                // no operation
}

void __interrupt_n IntWDT(void)
{
    NOP;                                // no operation
}

void __interrupt_n IntSWI(void)
{
    unsigned char *p_coming_opcode = ((*(unsigned short *)(__SP + (6 * 2) + 1)) - 1);
    unsigned char r_index;
    static const unsigned char a_invalid_opcode[] = {  /* invalid opcode */
            0x01,0x02,0x03,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0xf8,0xff };
	
	// Is Invalid Op Code
    for ( r_index = 0; r_index < ( sizeof(a_invalid_opcode)/sizeof(a_invalid_opcode[0])); r_index++ )
    {
        if ( *p_coming_opcode == a_invalid_opcode[r_index] )
            SYSCR2 = 0x10;	// invalid opcode(s) --> system clock reset
    }
	
    // adjust address for return from IntSWI // '
    (*(unsigned short *)(__SP + (6 * 2) + 1))--;
		
    // cost 6 bytes for fix stack //
    __asm("dec	wa");
    __asm("dec	bc");
    __asm("dec	de");
    __asm("dec	hl");
    __asm("dec	ix");
    __asm("dec	iy");
}

/* ------------------- end of interrupt service routine ------------------ */

/* -------------------- MQ6801 interrupt vector ------------------ */
//[ ж ] Ҫжид
//  1. ʹ֮߳жж֮OnlyRetiΪӦж
//  2. ӦڵַжƣֱӸ
//
//ʹⲿж2ӦжϱеOnlyRetiΪInt2
//      Int2,            /* 0xffda : Int2 */        //ⲿж2
#pragma section const INT_VECTOR1     
void * const IntTbl1[] = {  
    OnlyReti,			/* 0xffcc : IntTC03 */
    OnlyReti,			/* 0xffce : IntTC02 */
    OnlyReti,			/* 0xffd0 : IntTXD1 */
    OnlyReti,			/* 0xffd2 : IntRXD1 */
    OnlyReti,			/* 0xffd4 : Reserved */	
    OnlyReti,			/* 0xffd6 : Int4 */
    OnlyReti,			/* 0xffd8 : Int3 */
    Int2,		        /* 0xffda : Int2 */
    OnlyReti,			/* 0xffdc : Reserved */
    OnlyReti,			/* 0xffde : Reserved */
    OnlyReti,			/* 0xffe0 : Reserved */
    OnlyReti,			/* 0xffe2 : IntTCA0  */
    OnlyReti,			/* 0xffe4 : IntTC01 */
    OnlyReti,			/* 0xffe6 : IntTC00 */
    OnlyReti,			/* 0xffe8 : IntRTC */
    OnlyReti,			/* 0xffea : IntADC */
    OnlyReti,			/* 0xffec : IntVLTD */
    OnlyReti,			/* 0xffee : Reserved */
    OnlyReti,			/* 0xfff0 : Reserved */
    OnlyReti,			/* 0xfff2 : Reserved */
    OnlyReti,			/* 0xfff4 : IntTBT */
    OnlyReti,	    	/* 0xfff6 : IntWUC */
    IntWDT,				/* 0xfff8 : IntWDT */
    (void *)0xffff,		/* 0xfffa : Reserved */
    IntSWI,	   			/* 0xfffc : IntSWI/INTUNDEF */     
    STARTUP		    	/* 0xfffe : RESET */
};  
#pragma section const  			
/*------------------- end of interrupt vector ------------------------*/






//*********************************************************************
// name			: System_Init(void)
// brief		: IO, CGCR and P10/P40/P41 initialization during debugging
// note			:
//*********************************************************************
void System_Init(void)
{

//=============================================================================
//  Set CGCR
//=============================================================================
//  ============================================
//  clock gear control registerCGCR                                  fc   =  8MHz
//  ============================================
//  CGCR_FCGCKSEL = 0x00;           // (system clock) fcgck = fc/4 =  2Mhz(default)
//  CGCR_FCGCKSEL = 0x01;           // (system clock) fcgck = fc/2 =  4Mhz
//  CGCR_FCGCKSEL = 0x02;           // (system clock) fcgck = fc   =  8Mhz
//  CGCR_FCGCKSEL = 0x03;           // (system clock) fcgck = fc/8 =  1Mhz
//  ============================================
//  *** do not change the value of CGCR<FCGCKSEL> register in low-speed mode (SLOW1/SLOW2)
//  ============================================

#ifdef _DEBUG   //...  _DEBUG: for emulation of ev board
//------------------------------------------------------------------
//  (default): when emulation, set P10 to Reset pin to avoid affecting the emulation and program functions
    SET_P10_RESET_PIN;
	
// set FSCTRL bit0 to 0 is to use the internal low-speed clock, if the program has changed this bit, you need to manually initialize and clear it to the default value of 0 in the emulation mode 
	FSCTRL =( FSCTRL & 0xFE) | ( ((*(unsigned char*)(0x7e04))<<2)&0xC0) | 0x00;   //_DEBUG(please set to 0 in emulation mode)
// set FSCTRL bit0 to 1 is to use the external low-speed clock
   //FSCTRL =( FSCTRL & 0xFE) | ( ((*(unsigned char*)(0x7e04))<<2)&0xC0) | 0x01;	
//------------------------------------------------------------------
#else           //...  in general power on and run the program (in non-emulation mode), set P10 to GPIO pin
//------------------------------------------------------------------
//-- set P10 to GPIO pin ------
    SET_P10_IO_PIN;
//------------------------------------------------------------------
	
//------------------------------------------------------------------

#endif

	CGCR_FCGCKSEL = 0x01;           // (system clock) fcgck = fc/2 =  4Mhz

//-- pin configuration initialization (debug pin configuration)------
#ifdef _DEBUG   //...  _DEBUG: for emulation of ev board
//------------------------------------------------------------------
//  the simulation uses P10, P40 and P41 into Debug mode, which is set as an input during simulation
//  to avoid affecting the emulation and program functions
    P1DR = 0x00;
    P1CR = set8bit(11111110);           // set P10 as input pin
    P4DR = 0x00;
    P4CR = set8bit(11111100);           // set P40 and P41 as input pins
//------------------------------------------------------------------
#else           //...  in general power on and run the program (in non-emulation mode)
//------------------------------------------------------------------
    P1DR = 0x00;
    P1CR = 0x01;
    P4DR = 0x00;				
    P4CR = 0x2f;                        //P45 Set UnPad pins output LOW
//------------------------------------------------------------------
#endif

//-- pin configuration initialization ------
    P0DR = 0x00;
    P0CR = set8bit(11111100);
    P1DR = 0x00;
    P1CR = 0x01;
//  P2DR = 0x00;
//  P2CR = 0xff;
    P4DR = 0x00;
    P4CR = 0xff;    
    P7DR = 0x00;                        //P72, P74 Set UnPad pins output LOW
    P7CR = 0xf7;
    P8DR = 0x00;                        //P81 Set UnPad pins output LOW
    P8CR = 0x03;
    P9DR = 0x00;
    P9CR = 0x03;
    CLR_WDT;                            // clear the watchdog timer

}


//*********************************************************************
// name			:
// brief		: time delay function
// note			: ==> t_1ms   = 0;          // time delay unit ms
//          : ==> t_100us = 1;          // time delay unit us (this accuracy is not good)
//          : the example of using a fixed loop with a time delay is as follows:
//          : Delay_Times(t_1ms, 800);  // delay 800ms
//*********************************************************************
void Delay_Times(uchar tBase, uint x)
{
    uint  i, cgcrT;

    uchar cgcrF[4]={ 2, 4,  8, 1 };     // use this array when the high-speed crystal frequency is 8MHz
//  uchar cgcrF[4]={ 4, 8, 16, 2 };     // use this array when the high-speed crystal frequency is 16MHz

//  the time delay function of the system at NORMAL1 mode and NORMAL2 mode
    if( SYSCR2_SYSCK == 0 )
    {
        cgcrT = cgcrF[CGCR_FCGCKSEL];   // 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
        switch(tBase)
        {
            case 0:                     // t_1ms
                cgcrT *= 110;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
            case 1:                     // t_100us
                cgcrT *= 11;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
        }
    }
//  the time delay function of the system at SLOW1 mode and SLOW2 mode), which has a large error, is used for reference
    else for(; x>0; x--){}

    CLR_WDT;                            // clear the watchdog timer
}










